<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>HMIS Login</title>
    <!-- Local Bootstrap CSS -->
    <link href="<?= base_url('assets/css/bootstrap.min.css') ?>" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #71b7e6, #9b59b6);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', sans-serif;
        }
        .card {
            border-radius: 1rem;
        }
        .btn-gradient {
            background: linear-gradient(45deg, #6a11cb, #2575fc);
            color: #fff;
            border: none;
        }
        .btn-gradient:hover {
            opacity: 0.9;
        }
        .fingerprint-section {
            margin-top: 20px;
            padding-top: 10px;
            border-top: 1px solid #ddd;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-5 col-lg-4">
            <div class="card shadow-lg p-4">
                <h3 class="text-center mb-4">Hospital MIS</h3>

                <?php if(session()->getFlashdata('error')): ?>
                    <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
                <?php endif; ?>

                <!-- Email/Password Login -->
                <form method="post" action="<?= site_url('auth/login') ?>">
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" class="form-control" placeholder="Enter email" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Password</label>
                        <input type="password" name="password" class="form-control" placeholder="Enter password" required>
                    </div>
                    <button class="btn btn-gradient w-100 mb-3">Login</button>
                </form>

                <!-- Fingerprint Login -->
                <div class="fingerprint-section">
                    <h6 class="text-center mb-3">Or Login via Fingerprint</h6>
                    <form method="post" action="<?= site_url('auth/fingerprintLogin') ?>">
                        <div class="mb-3">
                            <input type="text" name="fingerprint_data" class="form-control" placeholder="Enter fingerprint data" required>
                        </div>
                        <button class="btn btn-success w-100">Fingerprint Login</button>
                    </form>
                </div>
            </div>

            <p class="text-center mt-3 text-white">&copy; <?= date('Y') ?> HMIS Offline</p>
        </div>
    </div>
</div>

<!-- Local Bootstrap JS -->
<script src="<?= base_url('assets/js/bootstrap.bundle.min.js') ?>"></script>
</body>
</html>
